"""
Main URL configuration for Bizness Navigator
"""
from django.contrib import admin
from django.urls import path, include
from django.conf import settings
from django.conf.urls.static import static
from django.views.generic import TemplateView
from django.contrib.auth import views as auth_views
from django.conf.urls.i18n import i18n_patterns

from locations import views

urlpatterns = [
    path('admin/', admin.site.urls),
    path('i18n/', include('django.conf.urls.i18n')),
    path('rosetta/', include('rosetta.urls')),  # ⭐ ДОБАВЛЕНО - для переводов
]

# URL с поддержкой языков
urlpatterns += i18n_patterns(
    # Главная страница
    path('', TemplateView.as_view(template_name='home.html'), name='home'),

    # Бизнес модули
    path('dashboard/', include('businesses.urls')),
    path('locations/', include('locations.urls')),

    # Аутентификация
    path('accounts/', include('django.contrib.auth.urls')),
    path('logout/', auth_views.LogoutView.as_view(next_page='home'), name='logout'),

    # Поиск локаций
    path('search/', views.location_search, name='location_search'),
)

# Media and Static
if settings.DEBUG:
    urlpatterns += static(settings.MEDIA_URL, document_root=settings.MEDIA_ROOT)
    urlpatterns += static(settings.STATIC_URL, document_root=settings.STATIC_ROOT)