# Generated by Django 5.2.8 on 2025-11-28 17:00

import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='BusinessCategory',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100, verbose_name='Название')),
                ('name_uz', models.CharField(max_length=100, verbose_name='Nomi (UZ)')),
                ('description', models.TextField(verbose_name='Описание')),
                ('icon', models.CharField(default='briefcase', max_length=50)),
            ],
            options={
                'verbose_name': 'Категория бизнеса',
                'verbose_name_plural': 'Категории бизнеса',
            },
        ),
        migrations.CreateModel(
            name='BusinessIdea',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=200, verbose_name='Название идеи')),
                ('description', models.TextField(verbose_name='Описание')),
                ('target_audience', models.TextField(verbose_name='Целевая аудитория')),
                ('investment_required', models.DecimalField(decimal_places=2, max_digits=12, verbose_name='Требуемые инвестиции')),
                ('potential_profit', models.DecimalField(decimal_places=2, max_digits=12, verbose_name='Потенциальная прибыль')),
                ('payback_period', models.IntegerField(verbose_name='Срок окупаемости (месяцы)')),
                ('market_analysis', models.JSONField(default=dict, verbose_name='Анализ рынка')),
                ('competitors', models.JSONField(default=list, verbose_name='Конкуренты')),
                ('ai_confidence', models.FloatField(default=0.0, verbose_name='Уверенность ИИ')),
                ('trends_data', models.JSONField(default=dict, verbose_name='Данные трендов')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('category', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='businesses.businesscategory')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'Бизнес-идея',
                'verbose_name_plural': 'Бизнес-идеи',
                'ordering': ['-created_at'],
            },
        ),
        migrations.CreateModel(
            name='Business',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=200, verbose_name='Название бизнеса')),
                ('description', models.TextField(verbose_name='Описание')),
                ('status', models.CharField(choices=[('idea', 'Идея'), ('planning', 'Планирование'), ('registration', 'Регистрация'), ('active', 'Активный'), ('suspended', 'Приостановлен')], default='idea', max_length=20)),
                ('initial_capital', models.DecimalField(decimal_places=2, default=0, max_digits=12)),
                ('monthly_expenses', models.DecimalField(decimal_places=2, default=0, max_digits=12)),
                ('monthly_revenue', models.DecimalField(decimal_places=2, default=0, max_digits=12)),
                ('financial_model', models.JSONField(default=dict, verbose_name='Финансовая модель')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
                ('category', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='businesses.businesscategory')),
                ('idea', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='businesses.businessidea')),
            ],
            options={
                'verbose_name': 'Бизнес',
                'verbose_name_plural': 'Бизнесы',
                'ordering': ['-created_at'],
            },
        ),
        migrations.CreateModel(
            name='FinancialPlan',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('period_start', models.DateField(verbose_name='Начало периода')),
                ('period_end', models.DateField(verbose_name='Конец периода')),
                ('projected_revenue', models.DecimalField(decimal_places=2, max_digits=12)),
                ('projected_expenses', models.DecimalField(decimal_places=2, max_digits=12)),
                ('projected_profit', models.DecimalField(decimal_places=2, max_digits=12)),
                ('revenue_breakdown', models.JSONField(default=dict)),
                ('expense_breakdown', models.JSONField(default=dict)),
                ('ai_recommendations', models.TextField(blank=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('business', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='financial_plans', to='businesses.business')),
            ],
            options={
                'verbose_name': 'Финансовый план',
                'verbose_name_plural': 'Финансовые планы',
                'ordering': ['-period_start'],
            },
        ),
    ]
