# Generated by Django 5.2.8 on 2025-11-28 18:16

import django.db.models.deletion
import django.utils.timezone
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('businesses', '0001_initial'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.AlterModelOptions(
            name='businesscategory',
            options={'ordering': ['name'], 'verbose_name': 'Категория бизнеса', 'verbose_name_plural': 'Категории бизнеса'},
        ),
        migrations.AlterModelOptions(
            name='financialplan',
            options={'ordering': ['-created_at'], 'verbose_name': 'Финансовый план', 'verbose_name_plural': 'Финансовые планы'},
        ),
        migrations.RemoveField(
            model_name='businesscategory',
            name='name_uz',
        ),
        migrations.AddField(
            model_name='business',
            name='inn',
            field=models.CharField(blank=True, max_length=50, verbose_name='ИНН'),
        ),
        migrations.AddField(
            model_name='business',
            name='legal_form',
            field=models.CharField(blank=True, max_length=100, verbose_name='Форма собственности'),
        ),
        migrations.AddField(
            model_name='business',
            name='registration_date',
            field=models.DateField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name='businesscategory',
            name='created_at',
            field=models.DateTimeField(auto_now_add=True, default=django.utils.timezone.now),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name='businesscategory',
            name='updated_at',
            field=models.DateTimeField(auto_now=True),
        ),
        migrations.AlterField(
            model_name='business',
            name='idea',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='businesses', to='businesses.businessidea'),
        ),
        migrations.AlterField(
            model_name='business',
            name='initial_capital',
            field=models.DecimalField(decimal_places=2, max_digits=12, verbose_name='Начальный капитал'),
        ),
        migrations.AlterField(
            model_name='business',
            name='monthly_expenses',
            field=models.DecimalField(decimal_places=2, default=0, max_digits=12, verbose_name='Месячные расходы'),
        ),
        migrations.AlterField(
            model_name='business',
            name='monthly_revenue',
            field=models.DecimalField(decimal_places=2, default=0, max_digits=12, verbose_name='Месячная выручка'),
        ),
        migrations.AlterField(
            model_name='business',
            name='status',
            field=models.CharField(choices=[('planning', 'Планирование'), ('registration', 'Регистрация'), ('active', 'Активный'), ('suspended', 'Приостановлен'), ('closed', 'Закрыт')], default='planning', max_length=20),
        ),
        migrations.AlterField(
            model_name='business',
            name='user',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='businesses', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AlterField(
            model_name='businesscategory',
            name='description',
            field=models.TextField(blank=True),
        ),
        migrations.AlterField(
            model_name='businesscategory',
            name='icon',
            field=models.CharField(blank=True, help_text='Emoji или иконка', max_length=50),
        ),
        migrations.AlterField(
            model_name='businessidea',
            name='ai_confidence',
            field=models.FloatField(default=0.0, verbose_name='Уверенность AI (0-1)'),
        ),
        migrations.AlterField(
            model_name='businessidea',
            name='category',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='businesses.businesscategory'),
        ),
        migrations.AlterField(
            model_name='businessidea',
            name='payback_period',
            field=models.IntegerField(verbose_name='Срок окупаемости (месяцев)'),
        ),
        migrations.AlterField(
            model_name='businessidea',
            name='potential_profit',
            field=models.DecimalField(decimal_places=2, max_digits=12, verbose_name='Потенциальная прибыль/мес'),
        ),
        migrations.AlterField(
            model_name='businessidea',
            name='title',
            field=models.CharField(max_length=200, verbose_name='Название'),
        ),
        migrations.AlterField(
            model_name='businessidea',
            name='trends_data',
            field=models.JSONField(default=dict, verbose_name='Тренды и аналитика'),
        ),
        migrations.AlterField(
            model_name='businessidea',
            name='user',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='business_ideas', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AlterField(
            model_name='financialplan',
            name='ai_recommendations',
            field=models.TextField(blank=True, verbose_name='Рекомендации AI'),
        ),
        migrations.AlterField(
            model_name='financialplan',
            name='expense_breakdown',
            field=models.JSONField(default=dict, verbose_name='Разбивка расходов'),
        ),
        migrations.AlterField(
            model_name='financialplan',
            name='projected_expenses',
            field=models.DecimalField(decimal_places=2, max_digits=12, verbose_name='Прогноз расходов'),
        ),
        migrations.AlterField(
            model_name='financialplan',
            name='projected_profit',
            field=models.DecimalField(decimal_places=2, max_digits=12, verbose_name='Прогноз прибыли'),
        ),
        migrations.AlterField(
            model_name='financialplan',
            name='projected_revenue',
            field=models.DecimalField(decimal_places=2, max_digits=12, verbose_name='Прогноз выручки'),
        ),
        migrations.AlterField(
            model_name='financialplan',
            name='revenue_breakdown',
            field=models.JSONField(default=list, verbose_name='Разбивка доходов'),
        ),
    ]
