# businesses/urls.py
"""
URLs for businesses app
"""
from django.urls import path
from . import views

urlpatterns = [
    # Dashboard
    path('', views.dashboard, name='dashboard'),

    # Бизнес-идеи
    path('ideas/generate/', views.generate_idea, name='generate_idea'),
    path('ideas/<int:idea_id>/', views.business_idea_detail, name='business_idea_detail'),
    path('ideas/<int:idea_id>/create-business/', views.create_business_from_idea, name='create_business_from_idea'),

    # Бизнесы
    path('businesses/', views.business_list, name='business_list'),
    path('businesses/<int:business_id>/', views.business_detail, name='business_detail'),
    path('businesses/<int:business_id>/update-status/', views.update_business_status, name='update_business_status'),

    # Финансы
    path('businesses/<int:business_id>/forecast/', views.financial_forecast, name='financial_forecast'),
    path('businesses/<int:business_id>/forecast/regenerate/', views.regenerate_forecast, name='regenerate_forecast'),

    # Профиль
    path('profile/', views.user_profile, name='user_profile'),

    # ⭐ ДОБАВЛЕНО - Регистрация
    path('register/', views.register, name='register'),
]