"""
Admin configuration for locations app
"""
from django.contrib import admin
from .models import ZoneType, Location, Restriction, LocationCheck, NearbyObject


@admin.register(ZoneType)
class ZoneTypeAdmin(admin.ModelAdmin):
    list_display = ['name', 'code']
    search_fields = ['name', 'code']


@admin.register(Location)
class LocationAdmin(admin.ModelAdmin):
    list_display = ['address', 'zone_type', 'area', 'rent_price', 'is_available', 'created_at']
    list_filter = ['zone_type', 'is_available', 'has_parking']
    search_fields = ['address', 'owner_contact']
    readonly_fields = ['created_at']


@admin.register(Restriction)
class RestrictionAdmin(admin.ModelAdmin):
    list_display = ['name', 'restriction_type', 'minimum_distance', 'is_active']
    list_filter = ['restriction_type', 'is_active']
    search_fields = ['name', 'description']


@admin.register(LocationCheck)
class LocationCheckAdmin(admin.ModelAdmin):
    list_display = ['user', 'address', 'business_type', 'status', 'suitability_score', 'created_at']
    list_filter = ['status', 'created_at']
    search_fields = ['address', 'business_type', 'user__username']
    readonly_fields = ['created_at']


@admin.register(NearbyObject)
class NearbyObjectAdmin(admin.ModelAdmin):
    list_display = ['name', 'object_type', 'address', 'created_at']
    list_filter = ['object_type', 'created_at']
    search_fields = ['name', 'address']