# Generated by Django 5.2.8 on 2025-11-28 17:00

import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Location',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('address', models.CharField(max_length=300, verbose_name='Адрес')),
                ('latitude', models.DecimalField(decimal_places=8, max_digits=10)),
                ('longitude', models.DecimalField(decimal_places=8, max_digits=11)),
                ('area', models.FloatField(verbose_name='Площадь (м²)')),
                ('floor', models.IntegerField(default=1, verbose_name='Этаж')),
                ('has_separate_entrance', models.BooleanField(default=False)),
                ('has_parking', models.BooleanField(default=False)),
                ('parking_spaces', models.IntegerField(default=0)),
                ('has_water', models.BooleanField(default=True)),
                ('has_sewage', models.BooleanField(default=True)),
                ('has_electricity', models.BooleanField(default=True)),
                ('has_gas', models.BooleanField(default=False)),
                ('has_ventilation', models.BooleanField(default=False)),
                ('rent_price', models.DecimalField(blank=True, decimal_places=2, max_digits=10, null=True)),
                ('sale_price', models.DecimalField(blank=True, decimal_places=2, max_digits=12, null=True)),
                ('is_available', models.BooleanField(default=True)),
                ('owner_contact', models.CharField(blank=True, max_length=200)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
            ],
            options={
                'verbose_name': 'Локация',
                'verbose_name_plural': 'Локации',
            },
        ),
        migrations.CreateModel(
            name='NearbyObject',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=200)),
                ('object_type', models.CharField(choices=[('school', 'Школа'), ('kindergarten', 'Детский сад'), ('hospital', 'Больница'), ('mosque', 'Мечеть'), ('park', 'Парк'), ('market', 'Рынок'), ('transport', 'Остановка')], max_length=20)),
                ('address', models.CharField(max_length=300)),
                ('latitude', models.DecimalField(decimal_places=8, max_digits=10)),
                ('longitude', models.DecimalField(decimal_places=8, max_digits=11)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
            ],
            options={
                'verbose_name': 'Близлежащий объект',
                'verbose_name_plural': 'Близлежащие объекты',
            },
        ),
        migrations.CreateModel(
            name='Restriction',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=200, verbose_name='Название')),
                ('restriction_type', models.CharField(choices=[('distance', 'Дистанционное ограничение'), ('zone', 'Зональное ограничение'), ('license', 'Лицензионное требование'), ('sanitary', 'Санитарное требование'), ('fire', 'Пожарное требование')], max_length=20)),
                ('description', models.TextField(verbose_name='Описание')),
                ('restricted_object_type', models.CharField(blank=True, max_length=100)),
                ('minimum_distance', models.IntegerField(blank=True, help_text='Минимальная дистанция в метрах', null=True)),
                ('affected_categories', models.JSONField(default=list)),
                ('legal_reference', models.TextField(blank=True)),
                ('is_active', models.BooleanField(default=True)),
            ],
            options={
                'verbose_name': 'Ограничение',
                'verbose_name_plural': 'Ограничения',
            },
        ),
        migrations.CreateModel(
            name='ZoneType',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100, verbose_name='Название')),
                ('code', models.CharField(max_length=20, unique=True)),
                ('description', models.TextField()),
                ('allowed_business_types', models.JSONField(default=list)),
            ],
            options={
                'verbose_name': 'Тип зоны',
                'verbose_name_plural': 'Типы зон',
            },
        ),
        migrations.CreateModel(
            name='LocationCheck',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('address', models.CharField(max_length=300)),
                ('business_type', models.CharField(max_length=100)),
                ('latitude', models.DecimalField(decimal_places=8, max_digits=10, null=True)),
                ('longitude', models.DecimalField(decimal_places=8, max_digits=11, null=True)),
                ('status', models.CharField(choices=[('approved', 'Одобрено'), ('conditional', 'С условиями'), ('rejected', 'Отклонено')], max_length=20)),
                ('restrictions_found', models.JSONField(default=list)),
                ('requirements', models.JSONField(default=list)),
                ('nearby_objects', models.JSONField(default=list)),
                ('ai_analysis', models.TextField(verbose_name='ИИ анализ')),
                ('suitability_score', models.FloatField(default=0.0, verbose_name='Оценка пригодности')),
                ('estimated_cost', models.DecimalField(decimal_places=2, default=0, max_digits=10)),
                ('estimated_time_days', models.IntegerField(default=0)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('location', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='locations.location')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'Проверка локации',
                'verbose_name_plural': 'Проверки локаций',
                'ordering': ['-created_at'],
            },
        ),
        migrations.AddField(
            model_name='location',
            name='zone_type',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='locations.zonetype'),
        ),
    ]
