"""
URLs for locations app
УЛУЧШЕНИЯ: добавлены новые эндпоинты
"""
from django.urls import path
from . import views

app_name = 'locations'

urlpatterns = [
    # Основные страницы
    path('search/', views.location_search, name='search'),
    path('history/', views.location_history, name='history'),
    path('map/', views.location_map, name='map'),
    path('statistics/', views.location_statistics, name='statistics'),

    # Детали проверки
    path('check/<int:check_id>/', views.location_check_detail, name='check_detail'),

    # API endpoints
    path('api/check/', views.check_location_api, name='check_api'),
    path('api/nearby-suggestions/', views.nearby_suggestions_api, name='nearby_suggestions_api'),
    path('api/check/<int:check_id>/delete/', views.delete_location_check, name='delete_check'),
]